Ext.define('EgCitrixDashCloud.view.Components.Logon', {
    extend: 'Ext.Component',
    alias: 'widget.logon',
	legendFontColor: (strSkin == "Light") ? "#2a292a" : "#2a292a",
    titleFontColor: (strSkin == "Light") ? "#414141" : "#fff",
    axisFontColor: (strSkin == "Light") ? "#969696" : "#fff",
    gridLineColor: (strSkin == "Light") ? "#e1e1e1" : "#e1e1e1",
    noDataBg: (strSkin == "Light") ? "#fff" : "#fff",
	chartPropsNew:function(value)
	{
		var self = this;
		var xaxisLabel = true;
		var data = value.value;
		return {
			chart: {
				renderTo: self.id,
                width:self.getWidth(),
                height:self.getHeight(),
				spacingRight: 0,
				backgroundColor: null,
				style: {
					fontFamily: 'Roboto',
					fontWeight: 'normal'
				},
				styledMode: true
			},
			rangeSelector: {
				enabled: false
			},
			global: {
				useUTC: true
			},
			exporting: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			title: "",
			tooltip: {
				shared: true,
				shape: "square",
				useHTML: true,
				style: {
					color: '#494848',
					fontSize: '10px',
					fontWeight: 500,
					fontFamily: 'Roboto'
				},
				formatter: function () {
					var points = this.points;
					var pointsLength = points.length;
					var tooltipMarkup = pointsLength ? '<span style="font-size: 10px">' + Highcharts.dateFormat("%H:%M%p", new Date(this.x)) + '</span><br/>' : '';
					var index;
					var y_value;

					for (index = 0; index < pointsLength; index += 1) {
						y_value = points[index].y;

						tooltipMarkup += '<span style="color:' + points[index].series.color + '">\u25CF</span> ' + points[index].series.name + ': <b>' + y_value + '</b><br/>';
					}

					return tooltipMarkup;
				}
			},
			xAxis: {
				events: {
					setExtremes: syncExtremes
				},
				crosshair: {
					width: 1.5,
					color: 'gray',
					dashStyle: 'shortdot'
				},
				labels: {
					enabled: xaxisLabel,
					style: {
						color: this.axisFontColor,
						fontSize: this.axisFontSize
					}
				},
				type: 'datetime',
				dateTimeLabelFormats: {
					hour: '%H:%M %P'
				},
				opposite: true,
				lineWidth: 0,
				minorGridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0
			},
			lang: {
				noData: this.noDataText
			},
			noData: {
				style: {
					fontSize: this.noDataFontSize,
					height: 60
				}

			},
			yAxis: {
				offset: -10,
				gridLineColor: this.gridLineColor,
				lineColor: this.gridLineColor,
				labels: {
					enabled: false,
					style: {
						color: this.axisFontColor,
						fontSize: this.axisFontSize
					}
				},
				min: 0,
				enabled: false,
				max: data.maxVal,
				tickInterval: 2
			},
			legend: {
				enabled: false
			},
			plotOptions: {
				series: {
					connectNulls: connectNullsFlag,
					states: {
						hover: {
							halo: {
								size: 1,
							}
						}
					},
				},
				area: {
					fillColor: {
						linearGradient: {
							x1: 0,
							y1: 0,
							x2: 0,
							y2: 1
						},
						stops: [
							[0, Highcharts.Color(data.color).setOpacity(0.5).get('rgba')],
							[1, Highcharts.Color(data.color).setOpacity(0).get('rgba')],
						]
					},
					marker: {
						enabled: false
					},
					lineWidth: 2,
					states: {
						hover: {
							lineWidth: 2
						}
					},
					threshold: null
				}
			},

			series: [{
				name: data.name,
				type: 'column',
				color: data.color,
				data: data.dataArray
			}, {
				name: data.splineName,
				type: 'area',
				color: data.splineColor,
				data: data.splineDataArray
			}]
		}
	},
    chartProps: function (value) {
		var self = this;
        var lineColor =  '#e1e1e1';
        if(!Ext.isEmpty(value.series)){
            if(Ext.isEmpty(value.series[0].data)){
				lineColor = 'transparent';
            }
        }
		
		if(!Ext.isEmpty(value.series) && value.series.length == 2)
		{
			value.series[1]["yAxis"] = 1;
		}

        return {
            chart: {              
                renderTo: self.id,
                width:self.getWidth(),
                height:self.getHeight(),
                spacing:[0, 10, 10, 10],
                backgroundColor: '#ffffff',
                style: {
                  fontFamily: 'Roboto',
                  fontWeight: '400'
                },
                plotBackgroundColor: null,
                styledMode: true,
                plotBorderWidth: 0,
                plotShadow: false,
            },
            credits: {
                enabled: false
              },
            title: {
                text: null,
                margin:0
            },
            noData:{
                attr:{
                    fill: '#fff',
                    padding: 10,
                    r: 0,
                    'stroke-width': 1,
                    stroke: '#dfdfdf',
                    zIndex: 6
                }
            },
			tooltip: {
                shared: true,
				xDateFormat:tooltipDateFormate,
				formatter:function()
				{
					var disp = "";
					disp = Highcharts.dateFormat(tooltipDateFormate,new Date(this.x)) +"<br/>";
					for(var t=0;t<this.points.length;t++)
					{
						var name = this.points[t].series.name;
						var val = this.points[t].y;
						if(name.match(".*\\d+.*")){
							name = name.replace(/[0-9]/g, '')
							disp += name+" : "+val+"<br/>";
						}
						else
							disp += name+" : "+val+"<br/>";
					}				
					return disp;
				}				
            },
            legend:{
                align:'center',
                useHTML:true,
                verticalAlign:'top',
                symbolHeight:5,
                symbolWidth:5,
               // symbolPadding:0,
                margin:0,
                itemStyle: {
                    fontFamily: 'Roboto',
                    fontWeight: 'normal',
                    lineHeight:'20px',
                    fontSize:'11px'
                }
            },
            yAxis:[{
                startOnTick: false,
                tickWidth:0,
                lineColor: lineColor,
                title: {
                    enabled: false,
                    text: null,
                },
				max:(value.hasOwnProperty('series') && value.series[0]["maxValue"] != null)?parseInt(value.series[0]["maxValue"]):null,
				opposite:true
            },{				
                startOnTick: false,
                tickWidth:0,
                lineColor: lineColor,
                title: {
                    enabled: false,
                    text: null,
                },
				max:(value.hasOwnProperty('series') && value.series[1]["maxValue"] != null)?parseInt(value.series[1]["maxValue"]):null,
            }],
            xAxis: {
                gridLineWidth: 0,
                tickWidth:0,
                lineColor: lineColor,
              
                startOnTick: false,
                type: 'datetime',
                dateTimeLabelFormats :{
                    day: dayFormat,    //ex- 01 Jan 2016
					hour: '%H:%M',
                 },
            },
            labels: {
                enabled: false
            },
            plotOptions:{
                series: {
                    pointWidth: 10,
					marker: {
						radius: 0
					}
                },
                spline: {
                    marker:{
                        enabled:false
                    }
                },
            },
            series: value.series

        };
    },
    config: {
        chartValue: {
        }
    },
    constructor: function (config) {
        this.initConfig(config);
        this.callParent(arguments);
    },
    applyChartValue: function (newValue, oldValue) {
        var self = this;
        return newValue;
    },
    setChartValue: function (newValue, oldValue) {
        var self = this;
        if (!Ext.isEmpty(Ext.get(self.id))) {
            new Highcharts.Chart(self.chartProps(newValue));
        }
        return newValue;
    },
    getChartValue:function(){
        var self = this;
        return self.chartValue;
    },
    updateChartValue: function(newValue,oldValue){
        var self = this;
        if (!Ext.isEmpty(Ext.get(self.id))) {
			var chart = $('#'+self.id).highcharts();
			if(chart){
				chart.destroy();
				chart = null;
				new Highcharts.Chart(self.chartProps(newValue));
			}
             //var chart = $('#'+self.body.id).highcharts();
            //chart.series[0].remove(true);
            //chart.addSeries(newValue.series[0]);
            //chart.redraw();
          
        }
       
        return newValue;
    },
    chartValue:{
            series:[]
    },
    initComponent: function () {
        var self = this;
        //self.on('boxready', function () {
            //new Highcharts.Chart(self.chartProps(self.chartValue));
          //}, self);
          self.on('resize', function (c) {
            if (!Ext.isEmpty(Ext.get(self.id))) {
                if(!Ext.isEmpty($('#'+self.id).highcharts())){
                    var chart = $('#'+self.id).highcharts(),
                    chartWidth = Ext.get(self.id).getWidth(),
                    chartHeight = Ext.get(self.id).getHeight();
                    chart.setSize(chartWidth,chartHeight,false);
                    chart.reflow();
                }
            }
        }, self);
        self.callParent();
    }
});